capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\DNSP 2025 benchmarking\Stata files\TFP Analysis\Data management"
set more off
log using Outputs/log/crDNSPbench25-firm, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Benchmarking
Author:  Michael Cunningham
File:    crDNSPbench25-firm.do
Initial Date:    20-May-2022
Revised Date:	 22-May-2025
--------------------------------------------------------------------------*/

local varlist revenue energy customers maxdemand ratchetmd circlength cmos ///
	price_cmos opex price_opex overheadst overheadd undergrst undergrd ///
    transform auc_overheadst auc_overheadd auc_undergrst auc_undergrd  ///
	auc_transform  	

local datfiles EVOdata.csv AGDdata.csv CITdata.csv ENDdata.csv ///
	ENXdata.csv ERGdata.csv ESSdata.csv JENdata.csv PCRdata.csv ///
	SAPdata.csv ANDdata.csv  TNDdata.csv UEDdata.csv

***	Read data ********

import excel using "Input/DNSP consolidated benchmarking data (2024).xlsx", ///
	sheet("Shazam DNSP Data") cellrange(A1:V249) clear firstrow case(l)
drop in 1
destring, replace	

***	Rename variables ********		
		
rename dnspyearidentifier			  dnspyear
rename totalrevenue                   revenue
rename customernumbers                customers	
rename maximumdemand                  maxdemand
rename ratchedmaximumdemand	          ratchetmd
rename circuitlength                  circlength	
rename customerminutesoffsupply       cmos	
rename pricecustomerminutesoffsuppl   price_cmos 	
rename priceopex                      price_opex	
rename overheadsubtransmissionlines   overheadst 	
rename overheaddistributionlinesund   overheadd
rename undergroundsubtransmissionline undergrst
rename undergrounddistributionlines   undergrd
rename transformersexcludingfirststa  transform
rename aucoverheadsubtransmission     auc_overheadst
rename aucoverheaddistribution        auc_overheadd
rename aucundergroundsubtransmission  auc_undergrst
rename aucundergrounddistribution     auc_undergrd
rename auctransformersexcludingfirst  auc_transform
rename shareofundergroundcables		  ucshare

***	Misc data management & save ********


gen int dnsp = int(dnspyear/100)
gen int year = dnspyear - dnsp*100 + 2000
	
replace cmos = 1 if cmos < 1

gen mdindex = 1
replace mdindex = (maxdemand / maxdemand[_n-1]) * mdindex[_n-1] if year > 2006
label variable mdindex      "Maximum demand index (2006 = 1)"		

format %14.0g `varlist'

label define dnsplab 1 "1.ACT: Evoenergy" 2 "2.AGD: Ausgrid" ///
	3 "3.CIT: CitiPower" 4 "4.END: Endeavour Energy" 5 "5.ENX: Energex" ///
	6 "6.ERG: Ergon Energy" 7 "7.ESS: Essential Energy" 8 "8.JEN: Jemena" ///
	9 "9.PCR: Powercor" 10 "10.SAP: SA Power Networks" ///
	11 "11.AND: AusNet Dist." 12 "12.TND: TasNetworks Dist." ///
	13 "13.UED: United Energy"																
label values dnsp dnsplab

sort dnsp year
xtset dnsp year

tab1 dnsp year
describe, f	
summarize `varlist' ucshare mdindex
misstable summarize `varlist' ucshare mdindex

save Outputs/dta/dnspbench25-firm, replace

*** Create individual DNSP & pooled DNSP Shazam input data files ********
		
local j = 1	
foreach k of local datfiles {
	outsheet year `varlist' mdindex using Outputs/csv/`k' if dnsp == `j', comma replace
	local ++j
}

outsheet dnspyear `varlist' ucshare using Outputs/csv/DNSPdata.csv, comma replace

log close
exit

